﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using AForge;
using Avi;
using InputDevices;
using AForge.Video;
using TwoCamWPF.Helpers;
using TwoCamWPF.Settings;
using System.Reflection;
using System.Windows.Forms;

namespace TwoCamWPF
{
    static class Program
    {
        /// <summary>
        /// Список ВСЕХ устройств видеозахвата
        /// </summary>
        static public Settings.ClassSettings settings;
        static public FileWatcher fileWatcher;

        static Program()
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Запуск программы ");
            Application.ThreadException += (s, e) => Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), e.Exception.Message);
      
            settings = Settings.ClassSettings.LoadSettings();
            settings.ReloadCamList();
            fileWatcher = new FileWatcher(settings);
            bool bk = false;
            settings.OnLocked += (_) =>
            {
                bk = fileWatcher.IsRecording;
                if (bk)
                    fileWatcher.IsRecording = false;
            };
            settings.OnLoaded += (_) =>
            {
                if (bk)
                    fileWatcher.IsRecording = true;
            };

        }

        public static void Close()
        {

            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Закрытие программы ");
           fileWatcher.Dispose();
        }
    }
}
